#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2014, Peter Pisljar'
__docformat__ = 'restructuredtext en'

if False:
    # This is here to keep my python error checker from complaining about
    # the builtin functions that will be defined by the plugin loading system
    # You do not need this code in your plugins
    get_icons = get_resources = None

# The class that all interface action plugins must inherit from
from PyQt4.Qt import QToolButton, QMenu, QDialog, QVBoxLayout, QPushButton, QMessageBox, QLabel, QLineEdit, QComboBox,  QCompleter,  QMainWindow,  QWidget,  QTextEdit
from calibre.gui2.actions import InterfaceAction
from calibre.gui2 import question_dialog
from calibre_plugins.solr_fulltext_search.config import prefs
from calibre_plugins.solr_fulltext_search.main import SolrFulltextSearchDialog
from calibre_plugins.count_pages.common_utils import (set_plugin_icon_resources, get_icon,
                                                    create_menu_action_unique)
import webbrowser
import urllib2
from subprocess import Popen, PIPE, STDOUT
import time
import os.path

class AboutWindow(QMainWindow):
    def __init__(self, parent=None):
        QMainWindow.__init__(self, parent)
        self.create_main_frame()       

    def create_main_frame(self):        
        page = QWidget()        

        self.button = QPushButton('OK', page)
        self.textWindow = QTextEdit()

        vbox1 = QVBoxLayout()
        vbox1.addWidget(self.textWindow)
        vbox1.addWidget(self.button)
        page.setLayout(vbox1)
        self.setCentralWidget(page)

        self.button.clicked.connect(self.clicked)

    def clicked(self):
        self.close()

class SolrFulltextSearchPlugin(InterfaceAction):

    name = 'Solr Full Text Search'

    # Declare the main action associated with this plugin
    # The keyboard shortcut can be None if you dont want to use a keyboard
    # shortcut. Remember that currently calibre has no central management for
    # keyboard shortcuts, so try to use an unusual/unused shortcut.
    action_spec = ('Solr Full Text Search', None,
            'Run the Solr Full Text Search', 'Ctrl+Shift+F1')

    def genesis(self):
        # This method is called once per plugin, do initial setup here
		self.is_library_selected = True
		self.menu = QMenu(self.gui)
		
		
        # Set the icon for this interface action
        # The get_icons function is a builtin function defined for all your
        # plugin code. It loads icons from the plugin zip file. It returns
        # QIcon objects, if you want the actual data, use the analogous
        # get_resources builtin function.
        #
        # Note that if you are loading more than one icon, for performance, you
        # should pass a list of names to get_icons. In this case, get_icons
        # will return a dictionary mapping names to QIcons. Names that
        # are not found in the zip file will result in null QIcons.
        icon = get_icons('images/icon.png')

		self.rebuild_menus()
		
        # The qaction is automatically created from the action_spec defined above
		self.qaction.setMenu(self.menu)
        self.qaction.setIcon(icon)
        self.qaction.triggered.connect(self.show_solr)	
		
		
		
	def rebuild_menus(self):
		m = self.menu
        m.clear()
		create_menu_action_unique(self, m, '&Open solr search', '',triggered=self.show_solr)
		m.addSeparator()
		create_menu_action_unique(self, m, '&Update solr index', '',triggered=self.update_index)
		create_menu_action_unique(self, m, '&Create solr index', '',triggered=self.create_index)
		m.addSeparator()
		create_menu_action_unique(self, m, '&Configure plugin', 'config.png',triggered=self.show_dialog)
		create_menu_action_unique(self, m, '&About', '',triggered=self.show_about)
	
	def isConfigured(self):
		if not os.path.isfile(prefs['pathToSolr']+'/start.jar'):
			if not question_dialog(self.gui, 'Configure plugin', '<p>'+
                'Plugin is not (correctly) configured. Do you want to configure it now ?',
                show_copy_button=False):
                return False
            self.show_dialog()
            return False
		return True	
		
	def show_solr(self):
		# check if solr is running and if not start it
		if not self.isConfigured():
			return
			
		try:
			urllib2.urlopen("http://localhost:8983/solr/browse").read()
		except:
			Popen([prefs['pathToJava']+'/bin/java','-jar',prefs['pathToSolr'] + '/start.jar'], shell=False, cwd=prefs['pathToSolr'])
			time.sleep(5)
			
			
		webbrowser.open("http://localhost:8983/solr/browse")
		
	def update_index(self):
		self.index('update');
	
	def create_index(self):
		self.index('create');
		
	def index(self, type):
		lastupdate = prefs['lastUpdate']
		
		if type == 'update':
			Popen(['calibredb','catalog',prefs['pathToLibrary']+'/export.xml','-s','date:=>'+lastupdate])
		else:
			Popen(['calibredb','catalog',prefs['pathToLibrary']+'/export.xml'])
			
		lastupdate = time.strftime("%Y-%m-%d");
		
		if not self.isConfigured():
			return
			
		try:
			urllib2.urlopen("http://localhost:8983/solr/browse").read()
		except:
			Popen([prefs['pathToJava']+'/bin/java','-jar',prefs['pathToSolr'] + '/start.jar'], shell=False, cwd=prefs['pathToSolr'])
			time.sleep(5)
			
		opener = urllib2.build_opener(urllib2.HTTPHandler)
		request = urllib2.Request('http://localhost:8983/solr/collection1/dataimport', data='command=full-import&clean=true&commit=true&wt=json&indent=true&verbose=false&optimize=false&debug=false')
		request.add_header('Content-Type', 'application/x-www-form-urlencoded')
		request.get_method = lambda: 'POST'
		url = opener.open(request)
		
		prefs['lastUpdate'] = lastupdate
		
    def show_dialog(self):
        # The base plugin object defined in __init__.py
        self.interface_action_base_plugin.do_user_config(self.gui)
        
	def show_about(self):
		# Get the about text from a file inside the plugin zip file
        # The get_resources function is a builtin function defined for all your
        # plugin code. It loads files from the plugin zip file. It returns
        # the bytes from the specified file.
        
        text = get_resources('about.txt')
        #box = QMessageBox()
        #box.about(self, 'About the Recoll Full Text Search \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t',text.decode('utf-8'))
        #self.resize(600, self.height())
        
        self.box = AboutWindow()
        self.box.setWindowTitle("About the Solr Full Text Search Plugin")
        self.box.textWindow.setText(text)
        self.box.textWindow.setReadOnly(True)
        self.box.resize(600, 500)
        self.box.show()
			
	def library_changed(self, db):
        # We need to reapply keyboard shortcuts after switching libraries
        self.rebuild_menus()

    def apply_settings(self):
        from calibre_plugins.solr_fulltext_search.config import prefs
        # In an actual non trivial plugin, you would probably need to
        # do something based on the settings in prefs
        prefs

